//
//
//

class BlizzardMaker extends effects;

var() int MaxChunks;
var() float HailDensity;

var int ChunkCount;
var float dropDistance;
var float timer;
var float Droptime;

function Tick(float deltaTime)
 {
 local float distance;
 local int direction;
 local HailChunk Chunk;
 local vector loc;
 local rotator r;
 // spawn a drop if needs be
 if (ChunkCount>=MaxChunks)
    return;

 timer+=deltaTime;
 if (timer<droptime)
    return;

 // spawn that drop in a random location
 direction=Rand(65535);
 distance=FRand()*CollisionRadius;
 r=RotRand();
 r.Pitch=0;
 r.Roll=0;
 loc=Location+(Normal(Vector(r))*distance);
 Chunk=Spawn(class'HailChunk',,,loc);
 if (Chunk==none)
    return;
 timer=0.0;
 Chunk.DrawScale=0.75+(FRand()*0.2);
 Chunk.Scaleglow=0.1+(FRand()*0.3);
 Chunk.master=self;
 Chunk.Mass*=(1.0+(Chunk.drawScale*3));
 Chunk.Velocity=vect(0,0,-32);
 ChunkCount++;
 Chunk.textureNum=Rand(3);
 //Chunk.skin=tex[i];
 droptime=1.05-HailDensity;
 }

function PostBeginPlay()
 {
 local vector start,end,hl,hn;
 local Actor A;
 local bool bFoundFloor;
 super.PostBeginPlay();
 start=Location;
 end=Location+Vect(0,0,-2048);
 do
   {
   A=Trace(hl,hn,end,start);
   if (A==Level)
      {
      bFoundFloor=true;
      dropdistance=VSize(Location-hl);
      }
   else
       {
       start=hl;
       if (A==none || start==end)
          bFoundFloor=true;
       }
   } until (bFoundFloor);

 }

function LoseADrop()
 {
 ChunkCount--;
 }

defaultproperties
{
     MaxChunks=256
     HailDensity=36.000000
     bHidden=True
     DrawType=DT_Sprite
     Texture=Texture'Markistan.Skins.BlizzardMakerIcon'
     Skin=Texture'Markistan.Skins.BlizzardMakerIcon'
     CollisionRadius=3072.000000
     CollisionHeight=2.000000
     bCollideActors=True
}
